%% CIS II Galen Kinematic Calibration 
%% Can Kocabalkanli, Spring 2020
%% Reads C, K, k_dof from csv files saved during virtual experiment, for test wrist trajetory

function [C, K, k_dof] = get_test_data_w2()

% Ideal Model
TC = table2array(readtable('test_fwd_kin_ideal_wrist_test.csv'));
% Worst Model
%TC = table2array(readtable('test_fwd_kin_sys_error1_wrist_test.csv'));
% Realistic Model
%TC = table2array(readtable('test_fwd_kin_sys_error2_wrist_test.csv'));
TK1 = table2array(readtable('wrist_test_mk2_60_4.csv'));

bh_pose = [-0.09 0.147 0.449];%[0 0 0];%[0.09 -0.147 -0.446 0 0 0];
ee_0_w = [0.75643 -0.1469409 0.29483197 0 0 0];


N = size(TK1, 1);
C = zeros(4,4,N);
T = zeros(4,4,N);
K = zeros(4,4,N);
k_dof = zeros(N, 5);
for i = 1:N
    kg1 = TK1(i,:).*[1000 1000 1000 1 1];
    k_dof(i,:) = kg1;
    Rk = rotx(kg1(4))*roty(kg1(5));%rotz(kg1(6));%%THIS IS AN ASSUMPTION
    %Rk = eye(3);
    k1 = forwardKinematics(kg1(1), kg1(2), kg1(3), kg1(4), kg1(5));
    kg_t = k1(1:3) - [0 0 268.9]' + [0 0 0.54083*1000]';  %; + bh_pose' - [0 0 268.9/1000]
    K(:,:,i) = [Rk kg_t; 0 0 0 1]; %TB \

    c1 = TC(i,:);
    c_t = c1(1:3)'*1000 - bh_pose'*1000; %!!! + [0 0 268.9]';%+ bh_pose'*1000 ; %- bh_pose(1:3)' - [0 0 268.9]';
    Rc = rotx(c1(6))*roty(c1(5))*rotz(c1(4));
    C(:,:,i) = [Rc c_t; 0 0 0 1];
    
    %C(:,:,i) = K(:,:,i)\T(:,:,i);
    
end



end